//
//  MPServiceUtils.h
//  StoryboardPlayer
//
//  Created by Andrew Pavlyukov on 7/15/09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void(^MPSubscribeUserEmailCallbackBlock)(BOOL subscribed);

@interface MPServiceUtils : NSObject
{
}
BOOL validateAppStoreReceipt(NSString* bundleIdentifier);

typedef enum _TextFieldType
{
    kTextFieldTypePresetName,
    kTextFieldTypeRegular,
    kTextFieldTypePresetCode
} MPTextFieldType;

@property (assign, getter = isAuthorizationAllowed) BOOL authorizationAllowed;

+ (id)sharedUtils;

- (BOOL)removeFileWithElevatedPrivilegesFromLocation:(NSString *)location;
- (BOOL)copyFileWithElevatedPrivilegesFromPath:(NSString *)from toPath:(NSString*)destination;
- (BOOL)copyLinkWithElevatedPrivilegesFromPath:(NSString *)aSrc toPath:(NSString *)aDst;
- (BOOL)createFolderWithElevatedPrivilegesAtPath:(NSString *)aPath;

- (BOOL)removeQuarantineAttributeForItemAtPath:(NSString *)aPath recursive:(BOOL)aRecursive;

- (NSString *)getPermissionsForItemAtPath:(NSString *)aPath;

- (BOOL)setPermissions:(NSString *)aPermissions forItemAtPath:(NSString *)aPath;

+ (NSDictionary*)dictWithRecieptPath:(NSString*)path;
+ (NSArray*)pathesForBundleID:(NSString*)bundleID;
+ (BOOL)connectedToNetwork;
+ (void)displayDropdownAlertViewWithMessage:(NSString*)message;
+ (NSString*)appDocumentsDir;
+ (NSString*)applicationCashesDirrectory;
+ (NSString*)currentMacAddress;
+ (NSString*)hardwareUUID;
+ (NSString*)applicationName;
+ (NSString*)reportAsRunFlagName;
+ (NSString*)fixedApplicationNameInString:(NSString*)string;
+ (BOOL)validateEmail:(NSString*)candidate;
+ (NSString*)hashStringFromString:(NSString*)stringToHash;
+ (void)reportAsRun;
+ (void)buyFullVersion;
+ (void)subscribeUserWithEmail:(NSString*)email completionHandler:(MPSubscribeUserEmailCallbackBlock)subscribed;
+ (void)subscribeUserWithEmail:(NSString*)email approve:(BOOL)approve completionHandler:(MPSubscribeUserEmailCallbackBlock)subscribed;
+ (NSDictionary*)externalProperties;
+ (NSString*)systemVersion;
+ (NSComparisonResult)currentVersionCompare:(NSString*)checkedVersion;
+ (BOOL)useMacAdressForActivation;
+ (void)setUseMacAdressForActivation:(BOOL)useMacAdress;
+ (NSString *)proVersionSuffix;
+ (void)setProVersionSuffix:(NSString *)proVersionSuffix;
+ (BOOL)isRetina;
+ (BOOL)parentScreenIsRetina;
+ (NSString*)currentLocalization;
+ (NSString *)actualLocalization;
+ (NSArray*)localInAppsIds;
+ (BOOL)isTextFieldStringValid:(NSString*)input forTextFieldType:(MPTextFieldType)type;
+ (CGFloat)backingScaleFactor;
+ (BOOL)needsToShowSmallerSharings;

@end
